/*
 * File: HappyBirthday.java
 * =================================================
 * A program that shows off the "birthday paradox:"
 * not very many people need to be in a room to
 * have a high chance that two of them share a
 * birthday.
 */

import acm.program.*;
import acm.util.*;

public class HappyBirthday extends ConsoleProgram {
	/* Number of days in the year. */
	private static final int NUM_DAYS = 365;
	
	/* Number of iterations to run the program for. */
	private static final int NUM_ITERATIONS = 100000;
	
	public void run() {
		/* Happy birthday!  Have a large font! */
		setFont("DejaVuSerif-BOLD-24");
		
		/* Track the total number of people across all iterations.
		 * This, divided by the number of iterations, is the average
		 * number required.
		 */
		int totalPeople = 0;
		for (int i = 0; i < NUM_ITERATIONS; i++) {
			totalPeople += numBirthdaysBeforeCollision();
		}
		
		/* Compute the average number of people required. */
		double average = (double)totalPeople / NUM_ITERATIONS;
		
		println("It took " + average + " people to have the same birthday.");
	}
	
	/**
	 * Simulates putting people into a room until two share a birthday,
	 * then returns how many people needed to be put in the room.
	 * 
	 * @return How many people were put in the room before two shared a birthday.
	 */
	private int numBirthdaysBeforeCollision() {
		/* Total number of people added. */
		int numPeople = 0;
		
		/* A boolean array tracking what birthdays have been used.  This
		 * uses the fact that boolean arrays default to storing false
		 * everywhere.
		 */
		boolean[] birthdays = new boolean[NUM_DAYS];
		
		RandomGenerator rgen = RandomGenerator.getInstance();
		
		while (true) {
			/* Choose a random day. */
			int day = rgen.nextInt(0, NUM_DAYS - 1);
			numPeople++;
			
			/* If someone already had this birthday, we're done. */
			if (birthdays[day] == true)
				break;
			
			/* Otherwise, record that someone had this birthday. */
			birthdays[day] = true;
		}
		
		return numPeople;
	}
}
